<%--
 This JSP is responsible for opening a new window for purposes of displaying
 the main UI frameset.  The "Connect" servlet dispatches to this page when
 the user is starting a new session with the HMC.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.connect.res.connect">
<html>
<head>
   <hmc:title><fmt:message key="openingwindowtitle"/></hmc:title>
   <meta http-equiv="Cache-Control" content="no-cache">
</head>
<body>

<%--
 If we're in reconnect processing, we also open windows for every running
 task.  We transfer the relevant information from the request parameters
 to the JavaScript code.
--%>
<c:if test="${not empty windowNames}">
<script type="text/javascript">
   var windowNames = [
    <c:forEach var="name" varStatus="loopStatus" items="${windowNames}">
       "<c:out value='${name}'/>" <c:if test="${!loopStatus.last}">,</c:if>
    </c:forEach>
       ];

   var windowURIs  = [
    <c:forEach var="uri" varStatus="loopStatus" items="${windowURIs}">
       "<c:out value='${uri}'/>" <c:if test="${!loopStatus.last}">,</c:if>
    </c:forEach>
       ];

   var windowOptions  = [
    <c:forEach var="options" varStatus="loopStatus" items="${windowOptions}">
       "<c:out value='${options}'/>" <c:if test="${!loopStatus.last}">,</c:if>
    </c:forEach>
       ];
</script>
</c:if>

<script type="text/javascript">
   newwin = window.open("/hmc/connects/mainuiFrameset.jsp?uiURL="+encodeURIComponent("<c:out value='${uiURL}' escapeXml='false'/>")+"&uiTitleKey="+encodeURIComponent("<c:out value='${uiTitleKey}' escapeXml='false'/>"), "<c:out value='${mainWindowName}' escapeXml='false'/>", "height="+screen.availHeight+",width="+screen.availWidth+",top=0,left=0,scrollbars,resizable");
   newwin.resizeTo(screen.availWidth,screen.availHeight);
   newwin.focus();

   <c:if test="${not empty windowNames}">
      for (var i=0; i<windowNames.length; ++i) {
         window.open(windowURIs[i], windowNames[i], windowOptions[i]);
      }
   </c:if>
</script>

<c:if test="${not empty closeWindow}">
<script type="text/javascript">
   try {
      window.close();
   } catch (e) {
      // Ignore exceptions
   }
</script>
</c:if>

<c:if test="${empty closeWindow}">
<fmt:message key="redirecting"/>

<script type="text/javascript">
   window.location.replace("/");
</script>
</c:if>

</body>
</html>
</fmt:bundle>
